/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xobj;

import uk.co.demon.obelisk.xobj.BinaryExpr;
import uk.co.demon.obelisk.xobj.Section;
import uk.co.demon.obelisk.xobj.SectionMap;
import uk.co.demon.obelisk.xobj.SymbolMap;
import uk.co.demon.obelisk.xobj.UnaryExpr;
import uk.co.demon.obelisk.xobj.Value;

public abstract class Expr {
    private static Value TRUE = new Value(null, 1L);
    private static Value FALSE = new Value(null, 0L);

    public static Expr land(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            if (lhs.resolve(null, null) != 0L && rhs.resolve(null, null) != 0L) {
                return TRUE;
            }
            return FALSE;
        }
        return new BinaryExpr.LAnd(lhs, rhs);
    }

    public static Expr lor(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            if (lhs.resolve(null, null) != 0L || rhs.resolve(null, null) != 0L) {
                return TRUE;
            }
            return FALSE;
        }
        return new BinaryExpr.LOr(lhs, rhs);
    }

    public static Expr lnot(Expr exp) {
        if (exp.isAbsolute()) {
            if (exp.resolve(null, null) != 0L) {
                return FALSE;
            }
            return TRUE;
        }
        return new UnaryExpr.Not(exp);
    }

    public static Expr and(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return new Value(null, lhs.resolve(null, null) & rhs.resolve(null, null));
        }
        return new BinaryExpr.And(lhs, rhs);
    }

    public static Expr or(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return new Value(null, lhs.resolve(null, null) | rhs.resolve(null, null));
        }
        return new BinaryExpr.Or(lhs, rhs);
    }

    public static Expr xor(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return new Value(null, lhs.resolve(null, null) ^ rhs.resolve(null, null));
        }
        return new BinaryExpr.Xor(lhs, rhs);
    }

    public static Expr cpl(Expr exp) {
        if (exp.isAbsolute()) {
            return new Value(null, exp.resolve(null, null) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return new UnaryExpr.Cpl(exp);
    }

    public static Expr add(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return new Value(null, lhs.resolve(null, null) + rhs.resolve(null, null));
        }
        if (lhs.isAbsolute() && rhs instanceof Value) {
            Value val = (Value)rhs;
            return new Value(val.getSection(), lhs.resolve(null, null) + val.getValue());
        }
        if (lhs instanceof Value && rhs.isAbsolute()) {
            Value val = (Value)lhs;
            return new Value(val.getSection(), val.getValue() + rhs.resolve(null, null));
        }
        return new BinaryExpr.Add(lhs, rhs);
    }

    public static Expr sub(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return new Value(null, lhs.resolve(null, null) - rhs.resolve(null, null));
        }
        if (lhs.isAbsolute() && rhs instanceof Value) {
            Value val = (Value)rhs;
            return new Value(val.getSection(), lhs.resolve(null, null) - val.getValue());
        }
        if (lhs instanceof Value && rhs.isAbsolute()) {
            Value val = (Value)lhs;
            return new Value(val.getSection(), val.getValue() - rhs.resolve(null, null));
        }
        if (lhs instanceof Value && rhs instanceof Value) {
            Value lh = (Value)lhs;
            Value rh = (Value)rhs;
            if (lh.getSection() == rh.getSection()) {
                return new Value(null, lh.getValue() - rh.getValue());
            }
        }
        return new BinaryExpr.Sub(lhs, rhs);
    }

    public static Expr mul(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return new Value(null, lhs.resolve(null, null) * rhs.resolve(null, null));
        }
        return new BinaryExpr.Mul(lhs, rhs);
    }

    public static Expr div(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return new Value(null, lhs.resolve(null, null) / rhs.resolve(null, null));
        }
        return new BinaryExpr.Div(lhs, rhs);
    }

    public static Expr mod(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return new Value(null, lhs.resolve(null, null) % rhs.resolve(null, null));
        }
        return new BinaryExpr.Mod(lhs, rhs);
    }

    public static Expr neg(Expr exp) {
        if (exp.isAbsolute()) {
            return new Value(null, -exp.resolve(null, null));
        }
        return new UnaryExpr.Neg(exp);
    }

    public static Expr shr(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return new Value(null, lhs.resolve(null, null) >> (int)rhs.resolve(null, null));
        }
        return new BinaryExpr.Shr(lhs, rhs);
    }

    public static Expr shl(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return new Value(null, lhs.resolve(null, null) << (int)rhs.resolve(null, null));
        }
        return new BinaryExpr.Shl(lhs, rhs);
    }

    public static Expr eq(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return lhs.resolve(null, null) == rhs.resolve(null, null) ? TRUE : FALSE;
        }
        return new BinaryExpr.Eq(lhs, rhs);
    }

    public static Expr ne(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return lhs.resolve(null, null) != rhs.resolve(null, null) ? TRUE : FALSE;
        }
        return new BinaryExpr.Ne(lhs, rhs);
    }

    public static Expr lt(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return lhs.resolve(null, null) < rhs.resolve(null, null) ? TRUE : FALSE;
        }
        return new BinaryExpr.Lt(lhs, rhs);
    }

    public static Expr le(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return lhs.resolve(null, null) <= rhs.resolve(null, null) ? TRUE : FALSE;
        }
        return new BinaryExpr.Le(lhs, rhs);
    }

    public static Expr gt(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return lhs.resolve(null, null) > rhs.resolve(null, null) ? TRUE : FALSE;
        }
        return new BinaryExpr.Gt(lhs, rhs);
    }

    public static Expr ge(Expr lhs, Expr rhs) {
        if (lhs.isAbsolute() && rhs.isAbsolute()) {
            return lhs.resolve(null, null) >= rhs.resolve(null, null) ? TRUE : FALSE;
        }
        return new BinaryExpr.Ge(lhs, rhs);
    }

    public abstract boolean isAbsolute();

    public final boolean isRelative() {
        return !this.isAbsolute();
    }

    public abstract boolean isExternal(Section var1);

    public abstract long resolve(SectionMap var1, SymbolMap var2);
}

